#!perl

use strict;
use warnings;

use File::Util;
use File::Copy;
use Archive::Tar;


# get the archive directory as command line argument
my $archive = $ARGV[0] || undef;


if (($archive) and (-d $archive))
{
	# if directory has been provided as command line argument
	
	# create the File::Utils object
	my $fu = File::Util->new();
	
	# get the archives in the archive directory
	my @filelist    = $fu->list_dir($archive, qw/--files-only/);
	my $no_of_files = $#filelist +1;

	#declare the counter variables
	my $pages = 0;
	my $structs = 0;
	my $i = 0;

	# create the tar object
	my $tar = Archive::Tar->new();	
	
	# iterate through all archives
	foreach my $file (@filelist)
	{

		
		# read the archive
		$tar->read($archive.'/'.$file);
		my $item = substr($file,0,index($file,'.tgz'));
		my $struct_count = $tar->get_content('c:/local/tce/items/'.$item.'/stat_struct.dmp');
		my $page_count   = $tar->get_content('c:/local/tce/items/'.$item.'/stat_pages.dmp');
		
		# add the figures
		$pages = $pages + $page_count;
		$structs = $structs + $struct_count;
		$i++;
		
		# print 
		$| = 1;
		print "$i von $no_of_files Vorgaengen \t $pages Seiten \t $structs Strukturelemente \r";
		
		# clear the tar object
		$tar->clear;
	}
	print "\n\n";
	print "Vorgaenge                   : $no_of_files \n";
	print "gescannte Seiten            : $pages \n";
	print "Strukturelemente            : $structs \n";
	print "Seiten pro Vorgang          : ".int($pages/$no_of_files)."\n";
	print "Strukturelemente pro Vorgang: ".($structs/$no_of_files)."\n";
}
else
{
	# if directory does not exist or no command line argument has been provided
	print "\n";
	print "Die korrekte Aufrufsyntax ist folgende: ";
	print "tce_count.pl <Archiv-Verzeichnis>\n\n";
	print "z.B.: tce_count.pl w:/vd18/Archiv/backup/ \n(bitte Vorwaertsschraegstriche verwenden)\n";
	print "\n";
}
exit(1);
