package TCE::Filter::ResolvePND;

use Template::Plugin::Filter;
use base qw( Template::Plugin::Filter );

use LWP::UserAgent;
use Data::Dumper;

sub init {
    my $self = shift;

    $self->{ _DYNAMIC } = 1;

    $self->install_filter($self->{ _CONFIG }->{ name } || 'ResolvePND');

    return $self;
}

sub filter {
    my ($self, $text, $args, $config) = @_;
    
    my $field_sep = chr(30);
    my $pnd_id = 0;
    
    my $ua = LWP::UserAgent->new();
    my $ask_gvk = 'http://gso.gbv.de/DB=2.1/PLAIN=ON/PPNSET?PPN='.$text;
    my $response = $ua->get($ask_gvk);
    if ($response->is_success)
    {
    	my $record = $response->content;
    	my @fields = split(/$field_sep/,$record);
    	my ($pnd_id_field) = grep(/^003U/,@fields);
    	#my ($pnd_id_field) = grep(/^007S/,@fields);
    	$pnd_id = substr($pnd_id_field,7);
    }
    return $pnd_id;
    #return  $response->content;
}

1;
