#!perl

use strict;
use warnings;

use CGI::Carp qw(fatalsToBrowser);
use Template;
use File::Util;
use CGI;

use TCE::Config;
use Pica::Records;

# create the File::Utils object
my $fu = File::Util->new();

# create the CGI object
my $cgi = CGI->new();
my $action = $cgi->param('action') || undef;


# clear the PICA downloadfile if required or create an empty one if there is none
if (($action eq 'deleteDownload') || !(-e $TCE::Config::PICA_HOME))
{
  open (FILE,">$TCE::Config::PICA_HOME");
  print FILE '';
  close FILE;
}



# Read the Goobi home directory
my @filelist = $fu->list_dir($TCE::Config::GOOBI_HOME, qw/--files-only/);

# Check the PICA download file
my $dwl_fileinfo = localtime($fu->last_modified($TCE::Config::PICA_HOME));
my $dwl_linecount = $fu->line_count($TCE::Config::PICA_HOME);
my $recs = Pica::Records->new($TCE::Config::PICA_HOME);


# return as HTML
my $template = Template->new({'INCLUDE_PATH' => $TCE::Config::TEMPLATES_DIR});
print $cgi->header( -type=>"text/html" );
$template->process('tce_newitem.tmpl',{'files' => \@filelist,'dwl_fileinfo' => $dwl_fileinfo, 'dwl_linecount' => $dwl_linecount, 'records' => $recs->all_records }) || die $template->error();	


exit(1);