function structElem(identifier) {
  /* ============ object properties ============ */
  this.metadata = new String;
  this.startpage = {order: 0, label: 'undefiniert', structId: null};
  this.endpage = {order: 0, label: 'undefiniert', structId: null};
  this.hierarchyLevel = 0;
  this.id = identifier;
  
  /* ============ object methods ================ */
  /* Storing Metadata:
    argument must be a string that holds the StructElements
    metadata encoded in PICA3
    fields are separated by a line break
    lines that do not start with a field identifier are joined with the 
    preceeding field.
    if the first line starts without a field identifier, field 4000 is
    assumed.
  */
    
  this.storeMetadata = function(data){
    this.metadata = '';
    var lines = data.split("\n");
    for (var i = 0; i < lines.length; i++) {
      var fieldIdentifier = lines[i].substr(0,5);
      if (fieldIdentifier.match(/\d{4} /)) {
        this.metadata +=  "\n"+lines[i];
      }
      else{
        if (i == 0) {
          this.metadata += "\n"+"4000 "+lines[i];
        }
        else {
          this.metadata += " "+lines[i];
        }}}
    this.metadata = this.metadata.substr(1);
    };
 
  /* Displaying a short title 
    no arguments required
    displays content of field 4000, ending, if necessary at : 
    (blank, colon, blank)
  */       
  this.shorttitle = function(){
    var lines = this.metadata.split("\n");
    var title = 'Kein Titel';  
    for (var line of lines) {
       if (line.match(/^4000 /)) {
        title = line.substr(5).replace(/@/,"");
        if (title.indexOf(" : ") > 1) title = title.substr(0,title.indexOf(" : "));
        if (title.length > 50) title = title.substr(0,50) + "...";}
       
       if (line.match(/^4007 /) && title == 'Kein Titel') {
        title = line.substr(5).replace(/@/,"");
        if (title.indexOf(" : ") > 1) title = title.substr(0,title.indexOf(" : "));
        title = title.replace(/ :: /,": ");
        if (title.length > 38) title = title.substr(0,38) + "...";
        title = title + " [Rezension]";}
       
       if (line.match(/^9000 /) && title == 'Kein Titel') {
       	title = "[" + line.substr(5) +"]";
       	}}
    title = title.replace(/&/,"&amp;");
    title = title.replace(/</,"&lt;");
    title = title.replace(/>/,"&gt;");
    title = title.replace(/"/,"&quot;");
    return title;
  }
  
  /* moving the element up or down in the hierarchy
    no arguments required
  */
  this.levelUp = function() {
    this.hierarchyLevel++;
  }
  
  this.levelDown = function() {
    this.hierarchyLevel--;
  }
}