#!perl

use strict;
use warnings;


use Template;
use File::Util;
use CGI;

use TCE::Config;

# create the CGI object
my $cgi = CGI->new();

# create File::Util object
my $fu = File::Util->new();


# list all existing directories in $ITEMS
my @filelist = $fu->list_dir($TCE::Config::ITEMS, qw/--dirs-only --no-fsdots/);

#output to browser
my $template = Template->new({'INCLUDE_PATH' => $TCE::Config::TEMPLATES_DIR});
print $cgi->header( -type=>"text/html" );
$template->process('tce_listitems.tmpl',{'items' => \@filelist}) || die $template->error();	

exit(1);