#!perl

use strict;
use warnings;

use CGI;
use File::Util;
use Template;
use Data::Dumper;

use TCE::Config;

# global variables
our @messages;
our $go = 1;
my  $data = {};


our $msg_ok = $TCE::Config::MSG_SYMBOLS{'ok'};
our $msg_fail = $TCE::Config::MSG_SYMBOLS{'fail'};
our $msg_warn = $TCE::Config::MSG_SYMBOLS{'warn'};

# create the CGI object
my $cgi = CGI->new();

#receive cgi parameter
my $item_id    = $cgi->param('itemid') || error($msg_fail.' Es wurde kein Vorgangstitel angegeben.');
my $action     = $cgi->param('action') || undef;
my $userdata   = $cgi->param('data')   || undef;

# perform updates first, if any
if (($action eq 'updateCollections') && $go)
{
	open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'collections'};
	print FILE $userdata;
	close FILE;
	
	message("$msg_ok Digitale Kollektionen erfolgreich gespeichert.");
}

if (($action eq 'updateAgent') && $go)
{
	my $agentdata; 
	if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'})
	{
		$agentdata = read_file($TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'});
	}
	else
	{
		$agentdata = [\%TCE::Config::DEFAULT_AGENT];
	}
	my ($role,$type,$name) = split(/##/,$userdata);
	push @{$agentdata},{'role' => $role, 'type' => $type, 'name' => $name};
	open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'};
	print FILE Dumper $agentdata;
	close FILE;
	
	message("$msg_ok Agent erfolgreich hinzugefgt");
}

if (($action eq 'deleteAgent') && $go)
{
	my $agentdata; 
	if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'})
	{
		$agentdata = read_file($TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'});
	}
	else
	{
		$agentdata = [\%TCE::Config::DEFAULT_AGENT];
	}
	my ($role,$type,$name) = split(/##/,$userdata);
	
	my $i = 0;
	foreach my $agent (@{$agentdata})
	{
		splice (@{$agentdata},$i,1) if (($role eq $agent->{'role'}) && ($type eq $agent->{'type'}) && ($name eq $agent->{'name'}));
		$i++;
	}
	
	open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'};
	print FILE Dumper $agentdata;
	close FILE;
	
	message("$msg_ok Agent erfolgreich gelscht");
}

# Statistik Strukturelemente
if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'stat_struct'})
{
	open FILE, '<'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'stat_struct'};
	$data->{'statistics'}->{'struct'} = <FILE>;
	close FILE;
}
else
{
	message("$msg_warn Der Vorgang ist noch nicht bearbeitet worden. Vollstndige Statistiken stehen erst zur Verfgung, nachdem der Vorgang bearbeitet und gespeichert wurde");
}

# Seiten
if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'stat_pages'})
{
	open FILE, '<'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'stat_pages'};
	$data->{'statistics'}->{'pages'} = <FILE>;
	close FILE;
}


# collections einlesen
if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'collections'})
{
	open FILE, '<'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'collections'};
	while (my $collection = <FILE>)
	{
		chomp $collection;
		push @{$data->{'collections'}}, $collection;
	}
	close FILE;
}

# agents einlesen
if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'})
{
	$data->{'agents'} =  read_file($TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'});
}
else
{
	$data->{'agents'} = [\%TCE::Config::DEFAULT_AGENT];
}

if (-e $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'createdate'})
{
	$data->{'createdate'} =  read_file($TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'createdate'});
}
# weitere parameter einlesen


#output success/error messages to browser
my $template = Template->new({'INCLUDE_PATH' => $TCE::Config::TEMPLATES_DIR});
print $cgi->header( -type=>"text/html" );
$template->process('tce_metaitem.tmpl',{'messages' => \@messages, 'itemdata' => $data, 'itemid' => $item_id }) || die $template->error();	

exit(1);

sub error
{
	my $text = shift;
	push @messages, $text;
	$go = 0;
	return undef; 

}

sub message
{
	my $text = shift;
	push @messages, $text;
	return 1;
}

sub read_file
{
  my $filename = shift;
  open FILE, '<'.$filename;
  my @lines = <FILE>;
  close FILE;
  my $object = join('',@lines);
  my $VAR1;
  eval ($object);
  return $VAR1;	
}