#!perl

use strict;
use warnings;

use CGI;
use File::Util;

use TCE::Config;

# create the CGI object
my $cgi = CGI->new();
my $item = $cgi->param('itemid') || undef;

# create the File::Utils object
my $fu = File::Util->new();

# get the files
if (-d $TCE::Config::ITEMS.$item)
{
  my @files = $fu->list_dir($TCE::Config::ITEMS.$item, qw/--files-only/);
  foreach my $file (@files)
  {
    unlink($TCE::Config::ITEMS.$item.'/'.$file);
  }
  rmdir($TCE::Config::ITEMS.$item);
}

print $cgi->redirect($TCE::Config::CGI_BIN.'listitems.pl');

exit(1);