#!perl

use strict;
use warnings;

use CGI;
use JSON;
use Data::Dumper;
use File::Copy;

use TCE::Config;

# get CGI parameters
my $cgi = CGI->new;
my $structTree = $cgi->param('data') || undef;
my $item_id = $cgi->param('itemid') || undef;

# declare output variable
my $output = {
  'success' => 0,
};



if ($structTree && $item_id)
{
  # decode StructTree
  if ($structTree = from_json($structTree))
  {
    if (-d $TCE::Config::ITEMS.$item_id )
    {
      # make backup
      my $timestamp = time;
      move $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'struct'}, $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'struct'}.'_'.$timestamp;
      
      # save data
      open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'struct'};
      print FILE Dumper $structTree;
      close FILE;
      
      $output->{'success'} = 1;
      $output->{'message'} = "Strukturbaum erfolgreich gespeichert";
      
      # write statistics
      my $count = $#{$structTree} + 1;
      open FILE ,'>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'stat_struct'};
      print FILE $count;
      close FILE;
      
    }
    else
    {
      $output->{'message'} = "Der angegebene Vorgang existiert nicht, daher können die Daten nicht gespeichert werden.";
    }
  }
  else
  {
    $output->{'message'} = "Der Strukturbaum ist kein JSON Literal. Die Daten können daher nicht gespeichert werden.";
  }
}
else
{
  $output->{'message'} = "Der Vorgangstitel, der Strukturbaum oder beide wurden nicht gesendet. Daher können die Daten nicht korrekt gespeichert werden.";
}

print $cgi->header( -type=>"application/json" );
print to_json($output);

exit(1);



