#!perl

use strict;
use warnings;

use File::Util;
use CGI;
use Template;
use CGI::Carp qw(fatalsToBrowser);

use TCE::Config;


# create the CGI object
my $cgi = CGI->new();

# create the File::Utils object
my $fu = File::Util->new();


# get the search phrase
my $term = $cgi->param('search') || 'tgz';

# read the directory
my @filelist = $fu->list_dir($TCE::Config::ARCHIVE_DIR, qw/--files-only/); 
my @matches = grep {/$term/} @filelist;

# output to browser
my $template = Template->new({'INCLUDE_PATH' => $TCE::Config::TEMPLATES_DIR});
print $cgi->header( -type=>"text/html" );
$template->process('tce_listarchiveditems.tmpl',{'items' => \@matches}) || die $template->error();

exit(1);