#!perl

use strict;
use warnings;

#use CGI::Carp qw(fatalsToBrowser);

use CGI;
use File::Copy;
use File::Util;
use Template;
use XML::Simple;
use Data::Dumper;

use TCE::Config;


# global variables
our @messages;
our $go = 1;
our $shortened_structmap = [];
our $next_step = undef;


our $msg_ok = $TCE::Config::MSG_SYMBOLS{'ok'};
our $msg_fail = $TCE::Config::MSG_SYMBOLS{'fail'};
our $msg_warn = $TCE::Config::MSG_SYMBOLS{'warn'};

# create the File::Util object
my $fu = File::Util->new();

# create the CGI object
my $cgi = CGI->new();


#receive cgi parameter
my $goobi_file = $cgi->param('goobimetsfile') || error($msg_fail.' Es wurde keine Goobidatei (METS) ausgewhlt. Daher konnte kein neuer Vorgang angelegt werden.');
my $item_id    = $cgi->param('itemid') || error($msg_fail.' Es wurde kein Vorgangstitel angegeben. Daher konnte kein neuer Vorgang angelegt werden.');
my $update     = $cgi->param('update') || undef;

# trim whitespaces in item_id
$item_id =~ s/ //g;

if ($go)
{
  #create directory, if not exists
  if (!(-d $TCE::Config::ITEMS.$item_id))
  {
    message("$msg_ok Verzeichnis ".$TCE::Config::ITEMS.$item_id." erfolgreich angelegt.") if (mkdir $TCE::Config::ITEMS.$item_id);	
  }
  elsif ($update)
  {
    message("$msg_ok Verzeichnis ".$TCE::Config::ITEMS.$item_id." gefunden.");
  }
  else
  {
    error ("$msg_fail Verzeichnis ".$TCE::Config::ITEMS.$item_id." existiert bereits. Whlen Sie einen anderen Vorgangsnamen oder whlen Sie 'METS Datei neu einlesen' unter 'Vorgang bearbeiten'.");
  }

  #move goobi mets file
  if ((-e $TCE::Config::GOOBI_HOME.$goobi_file) && $go)
  {
    move $TCE::Config::GOOBI_HOME.$goobi_file, $TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'goobi'};
    message("$msg_ok Goobidatei (METS) erfolgreich in das Arbeitsverzeichnis kopiert");
    
    # try to delete the anchor file
    my $anchor_file = substr($goobi_file,0,index($goobi_file,'.xml')).'_anchor.xml';
    if (unlink $TCE::Config::GOOBI_HOME.$anchor_file) 
    {
    	message ("$msg_ok Ankerdatei ".$anchor_file." gelscht");
    } 
    else
    {
    	message ("$msg_warn Versuch Ankerdatei ".$anchor_file." zu lschen war nicht erfolgreich");	
    }
  }
  elsif ($go)
  {
    error("$msg_fail Goobidatei $goobi_file nicht gefunden. Daher konnte kein neuer Vorgang angelegt werden.");
  }
  
  # move pica download file
  if ($go && !$update)
  {
      if (-e $TCE::Config::PICA_HOME)
      {
        move $TCE::Config::PICA_HOME, $TCE::Config::ITEMS.$item_id.'/download.dwl';
        message("$msg_ok Pica-Downloadfile ins Arbeitsverzeichnis verschoben");
        $next_step = 'create_structmap';
      }
      else
      {
        message("$msg_fail $TCE::Config::PICA_HOME nicht gefunden.");
      }
  }
  
  # create agents file for metsHdr
  if ($go && !$update)
  {
  	open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'agents'};
	print FILE Dumper [\%TCE::Config::DEFAULT_AGENT];
	close FILE;

  	my $timestamp = get_timestamp(0);
  	open FILE, '>'.$TCE::Config::ITEMS.$item_id.'/'.$TCE::Config::DATA_STORAGE{'createdate'};
	print FILE Dumper $timestamp;
	close FILE;	
	
	message("$msg_ok Daten fr den METS Header angelegt.");
  }
}

#output success/error messages to browser
my $template = Template->new({'INCLUDE_PATH' => $TCE::Config::TEMPLATES_DIR});
print $cgi->header( -type=>"text/html" );
$template->process('tce_createitem.tmpl',{'messages' => \@messages, 'success' => $go, 'itemid' => $item_id, 'nextstep' => $next_step }) || die $template->error();	

exit(1);

sub error
{
	my $text = shift;
	push @messages, $text;
	$go = 0;
	return undef; 

}

sub message
{
	my $text = shift;
	push @messages, $text;
	return 1;
}

sub get_timestamp
{
	my $offset = shift;
	my @t = gmtime(time + $offset);
	return ($t[5] + 1900).'-'.sprintf("%02d",($t[4] + 1)).'-'.sprintf("%02d",$t[3]).'T'.sprintf("%02d",$t[2]).':'.sprintf("%02d",$t[1]).':'.sprintf("%02d",$t[0]).'Z';
}
