package TCE::Config;

use strict;
use warnings;

# application wide configuration settings
BEGIN {

# full url and path to script dir (trailing slash required)
our $CGI_BIN = 'http://localhost/cgi-bin/tce/';

# path to GOOBI home directory (trailing slash required) c:/local/tce/goobi/
our $GOOBI_HOME = 't:/';

# path to PICA download file
our $PICA_HOME = 'c:/local/tce/dwl/download.dwl';

# path to TCE item store (trailing slash required)
our $ITEMS = 'c:/local/tce/items/';

# path to XSLT stylesheets (trailing slash required)
our $STYLESHEET_DIR = 'c:/local/tce/stylesheets/';

# path to output directory (trailing slash required)
our $OUTPUT_DIR = 'c:/local/tce/output/';

# path to default archive location (trailing slash required)
our $ARCHIVE_DIR = 's:/VD18/archive/';

# path to backup archive (trailing slash required)
our $ARCHIVE_BACKUP = 's:/VD18/archive/backup/';

# path to TT templates (no trailing slash)
our $TEMPLATES_DIR = 'c:/local/tce/templates';

# PPN prefix
our $PPN_PREFIX = 'gvk';

# default filenames !!DO NOT CHANGE!!
our %DATA_STORAGE = (
  'struct' => 'struct.dmp',
  'pages' => 'pages.dmp',
  'volume' => 'volume.dwl',
  'goobi' => 'goobi.xml',
  'stat_struct' => 'stat_struct.dmp',
  'stat_pages' => 'stat_pages.dmp',
  'collections' => 'collections.txt',
  'images' => 'images.dmp',
  'agents' => 'agents.dmp',
  'createdate' => 'createdate.dmp'
);

# default message symbols
our %MSG_SYMBOLS = (
  'ok' => '<img src="/tce/include/images/plus.png" alt="[OK]" style="margin-bottom:-0.5em"/>',
  'fail' => '<img src="/tce/include/images/minus.png" alt="[FAIL]" style="margin-bottom:-0.5em"/>',
  'warn' => '<img src="/tce/include/images/exclamation.png" alt="[WARN]" style="margin-bottom:-0.5em"/>'
);

# base url for pointers
our $POINTER = 'http://gdz.sub.uni-goettingen.de/mets_export.php?PPN=';

# path to xslt processor (use Windows syntax when using Windows OS)
our $PATH_TO_SAXON = 'C:/windows/system32/java -jar C:/users/jahnke/saxon/saxonb9-1-0-1j/saxon9.jar';

# default agent for METS header
our %DEFAULT_AGENT = (
	'role' => 'CREATOR',
	'type' => 'ORGANIZATION',
	'name' => 'Nds. Staats- und Universittsbibliothek Gttingen (DE-7)'
);
}
1;