<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:GDZ="http://gdz.sub.uni-goettingen.de/" 
    xmlns:mets="http://www.loc.gov/METS/" 
    xmlns:mods="http://www.loc.gov/mods/v3" 
    xmlns:zvdd="http://namespace.deklarations.dummy/" 
    xmlns:dv="http://dfg-viewer.de/" 
    xmlns:met="http://sub.uni-goettingen.de/met/namespace" 
    xmlns:xlink="http://www.w3.org/1999/xlink" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:tce="http://www.sub.uni-goettingen.de/tce"
    xsi:schemaLocation="http://www.loc.gov/METS/ http://www.loc.gov/mets/mets.xsd http://www.loc.gov/mods/v3 http://www.loc.gov/standards/mods/v3/mods-3-2.xsd">
    
    <xsl:param name="sourcefile"/>
    <xsl:output method="xml" indent="yes"/>
    <xsl:strip-space elements="*"/>
    
    <!-- ROOT-Template -->
    <xsl:template match="/">
            <xsl:apply-templates/>
    </xsl:template> 
    
    <xsl:template match="mets:mets">
        <mets:mets>
            <xsl:apply-templates mode="inner"/>
        </mets:mets>
    </xsl:template>
    
    <xsl:template match="tce:insertFilesec" mode="inner">
            <xsl:copy-of select="document($sourcefile)/mets:mets/mets:fileSec"/>     
    </xsl:template>
    
    <xsl:template match="tce:insertStructmapPhysical" mode="inner">
        <mets:structMap TYPE="PHYSICAL">
            <mets:div DMDID="{@DMDID}" ID="PHYS_0000" TYPE="physSequence">
                <xsl:copy-of select="document($sourcefile)/mets:mets/mets:structMap[@TYPE='PHYSICAL']/mets:div/*"/>
            </mets:div>
        </mets:structMap>
    </xsl:template>
    
    <xsl:template match="mets:*" mode="inner">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Fallback -->
    <xsl:template match="@*|text()">
    </xsl:template>    
</xsl:stylesheet>